//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "froslina1.h"
#include <math.h>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
//  Obiekt pomocniczy - parametr roliny (np. dugo)
//  z procesem samomodyfikacji przypadkowej na szeroko Amutacja.
//  Gdy okrelono obydwie granice, nastpi 'przycicie' genu.
TGen :: TGen( double Ag, double Amutacja,
            double Amin/*=NIEOKRESLONY*/, double Amax/*=NIEOKRESLONY*/)
{
 g = Ag;
 mutacja = Amutacja;
 min = Amin;
 max = Amax;
}
//---------------------------------------------------------------------------
//  Pomocnicza funkcja, rozpraszajca pseudolosowo podan warto
//  i przycinajca j do podanego zakresu.
double TGen :: mutuj( double Ag, double Amut, double Amin, double Amax) const
{
 int a = 1000.0 * Amut;     //"poszerzony" zakres losowania
 double b = Ag + (random( 2*a)-a) / 1000.0;

 if( Amin != NIEOKRESLONY && Amax != NIEOKRESLONY)
 {
    if( b > Amax)
        b = Amax;
    if( b < Amin)
        b = Amin;
 }
 return b;
}
//---------------------------------------------------------------------------
//  Zwr warto rozproszon przypadkowo na gboko mutacja.
double TGen :: daj_zmutowany_parametr( void) const
{
 return mutuj( g, mutacja, min, max);
}
//---------------------------------------------------------------------------
//  Wersja "kolorowa" ...
TColor TGen :: daj_zmutowany_kolor( void) const
{
 TColor kolor = (TColor)g,
        kolor_mut = (TColor)mutacja,
        kolor_min = (TColor)min,
        kolor_max = (TColor)max;
 int r = GetRValue( kolor), r_mut, r_min, r_max;  //rozkad koloru na r, g, b
 int g = GetGValue( kolor), g_mut, g_min, g_max;
 int b = GetBValue( kolor), b_mut, b_min, b_max;

 r_mut = GetRValue( kolor_mut);
 g_mut = GetGValue( kolor_mut);
 b_mut = GetBValue( kolor_mut);
 if( min != NIEOKRESLONY && max != NIEOKRESLONY)
 {
    r_min = GetRValue( kolor_min),
    r_max = GetRValue( kolor_max);
    g_min = GetGValue( kolor_min),
    g_max = GetGValue( kolor_max);
    b_min = GetBValue( kolor_min),
    b_max = GetBValue( kolor_max);
 }
 else
 {
    r_min=g_min=b_min=0;
    r_max=g_max=b_max=255;
 }
 r = mutuj( r, r_mut, r_min, r_max);
 g = mutuj( g, g_mut, g_min, g_max);
 b = mutuj( b, b_mut, b_min, b_max);

 return RGB( r, g, b);          //synteza zmutowanych skadnikw
}
//---------------------------------------------------------------------------
//  Poka biece parametry mutacji
void TGen :: daj_min_max( double &Amin, double &Amax) const
{
 Amin = min;
 Amax = max;
}
//---------------------------------------------------------------------------
//  Poka biece parametry mutacji
void TGen :: daj_mut( double &Amut) const
{
 Amut = mutacja;
}
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormPaint(TObject *Sender)
{
 TGen Adlg( 4, 1, 3, 5);    //opis dugoci witki A
 TGen Agrubosc( 2, 0, 0, 5); //jej grubo,
 TGen Akolor( clSilver, 0x100000); //kolor,
 TGen Bdlg( 3, 1, 2, 4);    //analogicznie opis witki B
 TGen Bgrubosc( 1, 0, 0, 3);
 TGen Bkolor( clGreen, 0x505050);
 TGen kierunek( 90, 20);    //kt prowadzenia gazki
 TGen lzakret( 45, 10);     //kt odchylenia w lewo
 TGen rzakret( 45, 10);     //w prawo
 TGen odrost( 2, 0, 0, 3);  //wspczynnik zmutowania odrostu

 formula = "A";             //inicjowanie formuy

 rozwin();
 rozwin();
 rozwin();
 rozwin();
 rozwin();
 rozwin();
 POZYCJA = 0;               //inicjowanie algorytmu rysuj()
 rysuj( 150, 10, Adlg, Agrubosc, Akolor,
                 Bdlg, Bgrubosc, Bkolor,
                 kierunek, lzakret, rzakret,
                 odrost);
 POZYCJA = 0;               //inicjowanie algorytmu rysuj()
 rysuj( 150, 10, Adlg, Agrubosc, Akolor,
                 Bdlg, Bgrubosc, Bkolor,
                 kierunek, lzakret, rzakret,
                 odrost);
 POZYCJA = 0;               //inicjowanie algorytmu rysuj()
 rysuj( 150, 10, Adlg, Agrubosc, Akolor,
                 Bdlg, Bgrubosc, Bkolor,
                 kierunek, lzakret, rzakret,
                 odrost);
}
//---------------------------------------------------------------------------
//  Wzrost roliny
void TForm1 :: rozwin( void)
{
 String tmp;
 int i, dlg = formula.Length();
 char c;

 for( i = 1; i <= dlg; i ++)
 {
    c = formula[ i];
    switch( c)
    {
     case 'A':              //gazka typu A
                tmp += "B(LA)B(RA)A";
                break;
     case 'B':              //gazka typu B
                tmp += "BB";
                break;
     case 'R':              //zwrot w prawo
                tmp += "R";
                break;
     case 'L':              //zwrot w lewo
                tmp += "L";
                break;
     case '(':              //boczny odrost
                tmp += "(";
                break;
     case ')':              //koniec odrostu
                tmp += ")";
                break;
    }
 }
 formula = tmp;
}
//---------------------------------------------------------------------------
//  Interpretuj formu, poczwszy od pozycji POZYCJA.
//  Uwaga: bywa, e ta funkcja wywouje sam siebie.
//  Wtedy kluczowe znaczenie ma zewntrzna zmienna POZYCJA ...
void TForm1 ::  rysuj( double Ax0, double Ay0,
                TGen Adlg, TGen Agrub, TGen Akolor,
                TGen Bdlg, TGen Bgrub, TGen Bkolor,
                TGen Kierunek, TGen Lzakret, TGen Rzakret,
                TGen Odrost)
{
 double x0 = Ax0, y0 = Ay0;
 double adlg, agrub, bdlg, bgrub;   //biece parametry roliny
 TColor akolor, bkolor;
 double kierunek, lzakret, rzakret, odrost;

 double mutacja, min, max;  //pomocnicze


 int len = formula.Length();
 char c;
 double k = M_PI / 180.;    //stopnie na radiany

 while( POZYCJA < len)
 {
    adlg = Adlg.daj_zmutowany_parametr();
    agrub = Agrub.daj_zmutowany_parametr();
    akolor = Akolor.daj_zmutowany_kolor();

    bdlg = Bdlg.daj_zmutowany_parametr();
    bgrub = Bgrub.daj_zmutowany_parametr();
    bkolor = Bkolor.daj_zmutowany_kolor();

    kierunek = Kierunek.daj_zmutowany_parametr();
    lzakret = Lzakret.daj_zmutowany_parametr();
    rzakret = Rzakret.daj_zmutowany_parametr();

    odrost = Odrost.daj_zmutowany_parametr();

    c = formula[ ++POZYCJA];
    switch( c)
    {
     case 'A':              //wykrel odcinek 'A'
                Canvas -> Pen -> Width = agrub;
                Canvas -> Pen -> Color = akolor;
                Canvas -> MoveTo( x0, ClientHeight-y0);
                x0 += adlg * cos( k * kierunek);
                y0 += adlg * sin( k * kierunek);
                Canvas -> LineTo( x0, ClientHeight-y0);
//                Canvas -> Pixels[x0][ClientHeight-y0] = clBlue;
                break;
     case 'B':              //wykrel odcinek 'B'
                Canvas -> Pen -> Width = bgrub;
                Canvas -> Pen -> Color = bkolor;
                Canvas -> MoveTo( x0, ClientHeight-y0);
                x0 += bdlg * cos( k * kierunek);
                y0 += bdlg * sin( k * kierunek);
                Canvas -> LineTo( x0, ClientHeight-y0);
//                Canvas -> Pixels[x0][ClientHeight-y0] = clRed;
                break;
     case 'L':              //zwrot w lewo
                Kierunek.daj_min_max( min, max);
                Lzakret.daj_mut( mutacja);
                Kierunek = TGen( kierunek + lzakret, mutacja, min, max);
                break;
     case 'R':              //zwrot w prawo
                Kierunek.daj_min_max( min, max);
                Rzakret.daj_mut( mutacja);
                Kierunek = TGen( kierunek - rzakret, mutacja, min, max);
                break;
     case '(':              //odrost - wywoanie rekurencyjne.
                            //Zbuduj nowe geny z biecych parametrw
                {   Adlg.daj_min_max( min, max);
                    Adlg.daj_mut( mutacja);
                    TGen nowyAdlg( adlg, mutacja*odrost, min, max);

                    Agrub.daj_min_max( min, max);
                    Agrub.daj_mut( mutacja);
                    TGen nowyAgrub( agrub, mutacja*odrost, min, max);

                    Akolor.daj_min_max( min, max);
                    Akolor.daj_mut( mutacja);
                    TGen nowyAkolor( akolor, mutacja*odrost, min, max);

                    Bdlg.daj_min_max( min, max);
                    Bdlg.daj_mut( mutacja);
                    TGen nowyBdlg( bdlg, mutacja*odrost, min, max);

                    Bgrub.daj_min_max( min, max);
                    Bgrub.daj_mut( mutacja);
                    TGen nowyBgrub( bgrub, mutacja*odrost, min, max);

                    Bkolor.daj_min_max( min, max);
                    Bkolor.daj_mut( mutacja);
                    TGen nowyBkolor( bkolor, mutacja*odrost, min, max);

                    Kierunek.daj_min_max( min, max);
                    Kierunek.daj_mut( mutacja);
                    TGen nowyKierunek( kierunek, mutacja*odrost, min, max);

                    Lzakret.daj_min_max( min, max);
                    Lzakret.daj_mut( mutacja);
                    TGen nowyLzakret( lzakret, mutacja*odrost, min, max);

                    Rzakret.daj_min_max( min, max);
                    Rzakret.daj_mut( mutacja);
                    TGen nowyRzakret( rzakret, mutacja*odrost, min, max);

                    Odrost.daj_min_max( min, max);
                    Odrost.daj_mut( mutacja);
                    TGen nowyOdrost( odrost, mutacja*odrost, min, max);

                    rysuj( x0, y0, nowyAdlg, nowyAgrub, nowyAkolor,
                        nowyBdlg, nowyBgrub, nowyBkolor,
                        nowyKierunek, nowyLzakret, nowyRzakret,
                        nowyOdrost);
                }
                break;
     case ')':              //koniec odrostu
                return;
    }
 }
 return;
}
//---------------------------------------------------------------------------

